//  Listing 9.2. Przykad poczenia danych i funkcji w obrbie jednej klasy z wasnym zakresem widocznoci nazw

#include <iostream>
using namespace std;

// 'class scope' to zakres widocznoci nazw w obrbie klasy / struktury

struct Cylinder 
{        			// start of the class scope - to pocztek zakresu dla klasy
  double radius, height; 	// pola danych
  void setCylinder(double r, double h) 		// inicjowanie wymiarw walca
   { radius = r; height = h; }
  double getVolume() 				// obliczanie objtoci
   { return height * radius * radius * 3.141593; }
  void scaleCylinder(double factor) 		// skalowanie wymiarw
   { radius *= factor; height *= factor; } 	// 'factor' - to wspczynnik
  void printCylinder() 				// drukowanie stanu obiektu
   { cout << "promie: " <<radius << " wysoko: " <<height <<endl; }
} ;             		// end of class scope - to koniec zakresu dla klasy

int main()      		// przekazanie odpowiedzialnoci funkcjom - serwerom
{ 
  Cylinder c1, c2;       	// definiujemy dane dla programu
  c1.setCylinder(10,30); 
  c2.setCylinder(20,30);  	// inicjujemy obiekty klasy Cylinder
  cout << "\nWymiary pocztkowe pierwszego walca\n";
  c1.printCylinder();      	// pocztkowy wymiar pierwszego walca
  if (c1.getVolume() < c2.getVolume()) 		// porwnanie objtoci
   { 
     c1.scaleCylinder(1.2); 	// skalowanie wymiarw
     cout << "\nWymiary pierwszego walca po zmianie\n";    // wydruk nowych wymiarw
     c1.printCylinder(); 
    }
  else 				// w przeciwnym razie - nie rb nic
  cout << "\nWymiary pierwszego walca - bez zmian." << endl;
  return 0;
}
